<?php
// Opcional: ajuda a pegar erros mais cedo
// declare(strict_types=1);

// ==================== CONFIG API POSIÇÃO FILA ====================
const API_URL = "http://200.150.120.54:9090/attmonitor/api/posicao_fila_filiais.php";
const API_TOKEN = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOlwvXC9leGFtcGxlLm9yZyIsImF1ZCI6Imh0dHA6XC9cL2V4YW1wbGUuY29tIiwiaWF0IjoxMzU2OTk5NTI0LCJuYmYiOjEzNTcwMDAwMDAsImRhdGEiOnsibm9tZV9jb21wbGV0byI6IkFVVE9VU0VSIiwiZW1wcmVzYV9ncnVwbyI6IkFUVCIsImlkX25pdmVsIjoiNDAiLCJpZF9ub21lIjoiQVVUT1VTRVIifX0.uPj6t1cfiTjCCvPdT3OgV5se3ZNy0CH6XbvE0MV7vfs";
// << troque pelo seu token válido

/**
 * Chama a API de posição de fila por placa.
 */
function chamarApiPosicaoFila(string $placa): ?array {
    $payload = [
        "AttApi" => [
            "tipoOperacao" => "d_posicao_fila",
            "veiculo"      => mb_strtoupper($placa, 'UTF-8'),
        ]
    ];

    $ch = curl_init(API_URL);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_HTTPHEADER     => [
            "Content-Type: application/json",
            "token: " . API_TOKEN
        ],
        CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE),
        CURLOPT_TIMEOUT        => 15,
    ]);

    $res  = curl_exec($ch);
    $err  = curl_error($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($err || $http >= 400) {
        error_log("Erro API posição fila: {$err} HTTP: {$http}");
        return null;
    }

    $data = json_decode($res, true);
    return is_array($data) ? $data : null;
}

/**
 * yyyy-mm-dd -> dd/mm/yyyy
 */
function formatarDataBr(?string $yyyy_mm_dd): string {
    if (!$yyyy_mm_dd || strpos($yyyy_mm_dd, '-') === false) return "-";
    [$y,$m,$d] = explode('-', $yyyy_mm_dd);
    return sprintf("%02d/%02d/%04d", (int)$d,(int)$m,(int)$y);
}

// ==================== HELPERS JSON (opcionais, mas úteis) ====================
/** Lê JSON de um arquivo, retornando array ou [] */
function json_read_array(string $path): array {
    if (!is_file($path)) return [];
    $raw = @file_get_contents($path);
    $arr = json_decode((string)$raw, true);
    return is_array($arr) ? $arr : [];
}

/** Escrita atômica de JSON (evita corromper arquivo) */
function json_atomic_write(string $path, array $data): bool {
    $tmp = $path . '.tmp';
    $ok1 = @file_put_contents($tmp, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
    if ($ok1 === false) return false;
    return @rename($tmp, $path);
}

// ==================== CONFIG Z-API (WhatsApp) ====================
const ZAPI_INSTANCE_ID     = "3E64A9590D5FC0486C70FE18C197E467";
const ZAPI_INSTANCE_TOKEN  = "65DABEC003D83220A10EB932";
const ZAPI_CLIENT_TOKEN    = "F8d5266d5def64937b2293519412fa62dS";

/**
 * Normaliza telefone BR para E.164 (WhatsApp/Z-API).
 * Ex.: "(43) 99116-5793" -> "5543991165793"
 * $modo: 'estrito' (não insere 9) | 'inserir9' (insere 9 após DDD se vier com 10 dígitos)
 */
function normalizarTelefoneBr(?string $raw, string $modo = 'estrito'): ?string {
    $raw = (string)$raw;
    if ($raw === '') return null;

    $d = preg_replace('/\D+/', '', $raw) ?? '';
    if ($d === '') return null;

    // remove 55 inicial duplicado, se existir
    if (strpos($d, '55') === 0 && strlen($d) >= 12) {
        $d = substr($d, 2);
    }

    // remove zeros à esquerda (ex.: 0XX)
    $d = ltrim($d, '0');

    // DDD + 9 + número
    if (strlen($d) === 11) {
        return '55' . $d;
    }

    // DDD + 8 dígitos (algumas bases antigas) -> opcional inserir '9'
    if (strlen($d) === 10 && $modo === 'inserir9') {
        $d = substr($d, 0, 2) . '9' . substr($d, 2);
        return '55' . $d;
    }

    // Já veio completo (55 + 11)
    if (strlen($d) === 13 && strpos($d, '55') === 0) {
        return $d;
    }

    return null;
}

/**
 * Envia mensagem de texto via Z-API para um número de WhatsApp (E.164).
 * Retorna true se a API retornar "messageId".
 */
function enviarWhatsApp(string $numero, string $mensagem): bool {
    $url = "https://api.z-api.io/instances/" . ZAPI_INSTANCE_ID . "/token/" . ZAPI_INSTANCE_TOKEN . "/send-text";

    $payload = json_encode([
        "phone"   => $numero,
        "message" => $mensagem
    ], JSON_UNESCAPED_UNICODE);

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_HTTPHEADER     => [
            "Content-Type: application/json",
            "Client-Token: " . ZAPI_CLIENT_TOKEN
        ],
        CURLOPT_POSTFIELDS     => $payload,
        CURLOPT_TIMEOUT        => 20,
    ]);

    $res  = curl_exec($ch);
    $err  = curl_error($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($err || $http >= 400) {
        error_log("Erro ao enviar WhatsApp: {$err} HTTP: {$http} RES: {$res}");
        return false;
    }

    $data = json_decode($res, true);
    return isset($data["messageId"]);
}

/**
 * Mensagem padrão de chamado para WhatsApp.
 * @param string      $placa   Ex.: "ABC1D23"
 * @param string      $dataBr  Ex.: "31/08/2025"
 * @param string      $hora    Ex.: "14:32"
 * @param string|null $empresa (opcional) Ex.: "ATT"
 * @param string|null $local   (opcional) Ex.: "balança" | "Balança 1"
 */
function montarMensagemChamado(string $placa, string $dataBr, string $hora, ?string $local = 'balança'): string {
    $local = $local ?: 'balança'; // garante texto
    return sprintf(
        "ATENÇÃO: seu caminhão placa %s foi CHAMADO para descarregar em %s às %s,\nDirija-se à balança imediatamente ⚠️\n\nMensagem oficial do GRUPO ATT",
        $placa,
        $dataBr,
        $hora,
        $local
    );
}


// ==================== WEB PUSH (via minishlink/web-push) ====================
// composer require minishlink/web-push
require_once __DIR__ . '/vendor/autoload.php';

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

// VAPID - troque pelas suas chaves
const VAPID_SUBJECT = 'mailto:contato@grupoatt.log.br';
const VAPID_PUBLIC  = 'BMkFQ7WKmMnmBm5_NQntVf1hEDOX_c7EIEQS6sQ3k0vKBQjgAaJJfCJc0MEXth8RzwNUN_w7Co4S0Kua9Vn8yQw';
const VAPID_PRIVATE = 'b2tbV9mB7kq4AP98fYvNeoeYdjqi57VIfwcV3fuB9f4';

/**
 * Dispara Web Push para todos os inscritos de uma placa.
 * Lê subs.json (mapa placa -> array de subscriptions).
 */
function enviarPushPlaca(string $placa, string $titulo, string $mensagem, array $extraData = []): void {
    $subsFile = __DIR__ . '/subs.json';
    if (!is_file($subsFile)) return; // sem inscritos

    $todas = json_read_array($subsFile);
    $placa = strtoupper($placa);
    $lista = $todas[$placa] ?? [];
    if (empty($lista)) return;

    $payload = json_encode([
        'title' => $titulo,
        'body'  => $mensagem,
        'icon'  => 'assets/Logo-ATT2.png',
        'badge' => 'assets/Logo-ATT2.png',
        'data'  => array_merge(['url' => 'resultado'], $extraData),
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

    $webPush = new WebPush([
        'VAPID' => [
            'subject'    => VAPID_SUBJECT,
            'publicKey'  => VAPID_PUBLIC,
            'privateKey' => VAPID_PRIVATE,
        ],
    ]);
    $webPush->setDefaultOptions(['TTL' => 60]);

    foreach ($lista as $subArr) {
        if (is_array($subArr) && isset($subArr['endpoint'])) {
            $webPush->sendOneNotification(Subscription::create($subArr), $payload);
        }
    }

    // Limpa inscrições inválidas (404/410) após flush
    $novas = [];
    $i = 0;
    foreach ($webPush->flush() as $report) {
        $status = $report->getResponse() ? $report->getResponse()->getStatusCode() : null;
        if (!in_array($status, [404, 410], true)) {
            $novas[] = $lista[$i] ?? null;
        }
        $i++;
    }

    if (count($novas) !== count($lista)) {
        $todas[$placa] = array_values(array_filter($novas));
        json_atomic_write($subsFile, $todas);
    }
}




