<?php
session_start();

// Restaura a sessão a partir do cookie, se a sessão tiver expirado
if (empty($_SESSION['placa']) && !empty($_COOKIE['placa'])) {
  $_SESSION['placa'] = strtoupper($_COOKIE['placa']);
}

// Se já tem placa na sessão (vinda do cookie ou do POST anterior), pula pra resultado
if (!empty($_SESSION['placa'])) {
  header("Location: resultado");
  exit;
}

// Prioriza mensagem em flash (vinda do consulta.php) e depois ?erro=
$erro = $_SESSION['flash_erro'] ?? ($_GET['erro'] ?? '');
unset($_SESSION['flash_erro']);
?>

<style>
#dlg-diretrizes {
  width: min(720px, 92vw);
  border: none;
  padding: 0;
  border-radius: 14px;
  box-shadow: 0 20px 60px rgba(0,0,0,.25);
}

#dlg-diretrizes::backdrop { background: rgba(0,0,0,.4); }

#dlg-diretrizes .dlg-header {
  display: flex; justify-content: space-between; align-items: center;
  padding: 16px 20px; border-bottom: 1px solid #eee;
}
#dlg-diretrizes h2 { margin: 0; font-size: 18px; }

#dlg-diretrizes .dlg-close {
  background: transparent; border: 0; font-size: 22px; line-height: 1;
  cursor: pointer; padding: 6px 8px;
}

#dlg-diretrizes .dlg-content {
  padding: 16px 20px; max-height: 55vh; overflow: auto;
}

#dlg-diretrizes .dlg-footer {
  padding: 12px 20px; border-top: 1px solid #eee; display: flex; justify-content: flex-end; gap: 8px;
}

#dlg-diretrizes .dlg-footer button {
  background: #0b2d55; color: #fff; border: 0; border-radius: 8px; padding: 10px 14px; cursor: pointer;
}
#dlg-diretrizes .dlg-footer button:disabled { opacity:.6; cursor:not-allowed; }
    
    
    
</style>

<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <title>Consulta de Fila</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
  <meta name="theme-color" content="#0b2d55">
  <link rel="stylesheet" href="assets/style.css">
  <link rel="icon" type="image/png" href="assets/Logo-ATT2.png">
</head>
<body>
  <main class="wrap">
    <div class="top">
      <img src="assets/Logo-ATT2.png" alt="Grupo ATT" class="brand">

    </div>

    <h1 class="app-title">Consulta de Fila</h1>

    <form class="login-box" method="post" action="resultado" id="form-placa">
  <?php if ($erro): ?>
    <div class="msg-erro" id="msg-erro"><?= htmlspecialchars($erro) ?></div>
  <?php else: ?>
    <div class="msg-erro" id="msg-erro" style="display:none;"></div>
  <?php endif; ?>

  <label for="placa" class="sr-only">Placa</label>
  <input
    id="placa"
    name="placa"
    class="plate-input"
    type="text"
    inputmode="latin"
    autocapitalize="characters"
    autocomplete="off"
    maxlength="8"
    pattern="[A-Za-z0-9]{7,8}"
    placeholder="Digite a placa"
  >
  
    <!-- Aceite das diretrizes -->
 <div class="consent" style="margin:12px 0;">
  <input type="checkbox" id="diretrizes" name="diretrizes" required>
  <label for="diretrizes">
    Li e estou de acordo com o 
    <a href="#" id="abrir-diretrizes"><strong>Documento de Diretrizes</strong></a>.
  </label>
  <input type="hidden" name="diretrizes_versao" value="1.2-2025-08-18">
</div>


  <button class="cta" type="submit">Consultar</button>

  <div class="footer">© <?= date('Y') ?> Todos os direitos reservados Grupo ATT</div>
</form>

<dialog id="dlg-diretrizes" aria-labelledby="dlg-title" aria-describedby="dlg-body">
  <form method="dialog" style="margin:0;padding:0;">
    <div class="dlg-header" style="display:flex;justify-content:space-between;align-items:center;padding:16px 20px;border-bottom:1px solid #eee;">
      <h2 id="dlg-title" style="margin:0;font-size:18px;">Documento de Diretrizes – Consulta de Fila</h2>
      <button type="button" class="dlg-close" aria-label="Fechar" id="dlg-fechar" style="background:transparent;border:0;font-size:22px;padding:6px 8px;cursor:pointer;">×</button>
    </div>

    <div id="dlg-body" class="dlg-content" style="padding:16px 20px;max-height:55vh;overflow:auto;">
      <p>As informações exibidas são <strong>provisórias</strong> e destinadas exclusivamente à <strong>organização operacional da fila de descarga</strong>.</p>
      <ul>
        <li>Poderá ser exibida a <strong>placa do caminhão imediatamente à sua frente</strong>, apenas enquanto ambos estiverem na fila, para facilitar a identificação da ordem.</li>
        <li>Os dados <strong>não constituem divulgação pública</strong> e deixam de estar acessíveis após a saída da fila.</li>
        <li>As informações devem ser utilizadas <strong>somente para fins de orientação logística</strong>.</li>
      </ul>
      <p>Ao prosseguir, você declara estar ciente das diretrizes acima.</p>
    </div>

    <div class="dlg-footer" style="padding:12px 20px;border-top:1px solid #eee;display:flex;justify-content:flex-end;">
      <button type="button" id="dlg-concordo" style="background:#0b2d55;color:#fff;border:0;border-radius:8px;padding:10px 14px;cursor:pointer;">Concordo e fechar</button>
    </div>
  </form>
</dialog>



  </main>

  <script>
(function () {
  const form    = document.getElementById('form-placa');
  const input   = document.getElementById('placa');
  const msgErro = document.getElementById('msg-erro');
  const btn     = form.querySelector('button[type="submit"]');
  const chk     = document.getElementById('diretrizes');

  // Helpers
  function showError(t) {
    msgErro.textContent = t || 'Ocorreu um erro.';
    msgErro.style.display = 'block';
    msgErro.setAttribute('role', 'alert');
  }
  function hideError() {
    msgErro.textContent = '';
    msgErro.style.display = 'none';
    msgErro.removeAttribute('role');
  }
  function setLoading(isLoading) {
    if (!btn) return;
    btn.disabled = isLoading;
    btn.dataset.prevText ??= btn.textContent;
    btn.textContent = isLoading ? 'Consultando…' : btn.dataset.prevText;
  }

  // Sanitiza entrada: A-Z/0-9 e máx. 8
  input.addEventListener('input', () => {
    let v = input.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
    if (v.length > 8) v = v.slice(0, 8);
    input.value = v;
  });

  // Evita ultrapassar 8 chars sem bloquear navegação
  input.addEventListener('keydown', (e) => {
    const allowed = ['Backspace','Delete','ArrowLeft','ArrowRight','Tab','Home','End'];
    if (allowed.includes(e.key) || e.ctrlKey || e.metaKey) return;
    if (input.selectionStart !== input.selectionEnd) return; // há seleção
    if (input.value.length >= 8) e.preventDefault();
  });

  // Timeout para fetch
  function fetchWithTimeout(url, opts = {}, ms = 10000) {
    const controller = new AbortController();
    const id = setTimeout(() => controller.abort(), ms);
    const options = Object.assign({}, opts, { signal: controller.signal });
    return fetch(url, options).finally(() => clearTimeout(id));
  }

  form.addEventListener('submit', async (ev) => {
    ev.preventDefault();
    hideError();

    // 1) Validação do checkbox
    if (!chk || !chk.checked) {
      showError('Você precisa aceitar o Documento de Diretrizes.');
      chk?.focus();
      return;
    }

    // 2) Validação da placa
    const placa = (input.value || '').toUpperCase().trim();
    if (!placa) { showError('Informe a placa.'); input.focus(); return; }
    if (placa.length !== 7 && placa.length !== 8) {
      showError('A placa deve conter 7 ou 8 caracteres.');
      input.focus(); return;
    }
    if (!/^[A-Z0-9]+$/.test(placa)) {
      showError('Placa incorreta. Use apenas letras e números.');
      input.focus(); return;
    }

    setLoading(true);

    try {
      // 3) Valida no backend antes de enviar o POST final
      const url = 'api_consulta.php?placa=' + encodeURIComponent(placa);
      const r = await fetchWithTimeout(url, {
        cache: 'no-store',
        headers: {
          'Accept': 'application/json',
          // Evita caches intermediários
          'Cache-Control': 'no-store, no-cache, must-revalidate, max-age=0',
          'Pragma': 'no-cache',
        },
        credentials: 'same-origin',
      }, 10000);

      let data = {};
      try { data = await r.json(); } catch (_) {}

      const veiculo = data && data.dados && data.dados.dadosVeiculo ? data.dados.dadosVeiculo : null;

      if (!r.ok || !veiculo) {
        const msg = (data && (data.erro || data.mensagem)) || 'Placa não encontrada na fila no momento.';
        showError(msg);
        return;
      }

      // 4) Sucesso → submete o form de verdade (grava sessão/cookie no seu PHP)
      input.value = placa; // garante caixa alta limpa
      form.submit();

    } catch (err) {
      const aborted = (err && (err.name === 'AbortError'));
      showError(aborted ? 'Tempo de resposta excedido. Tente novamente.' : 'Falha ao verificar a placa. Tente novamente.');
    } finally {
      setLoading(false);
    }
  });
})();
</script>

<script>
(function(){
  const link   = document.getElementById('abrir-diretrizes');
  const dlg    = document.getElementById('dlg-diretrizes');
  const fechar = document.getElementById('dlg-fechar');
  const ok     = document.getElementById('dlg-concordo');

  if (!link || !dlg) return;

  // Abre
  link.addEventListener('click', (e) => {
    e.preventDefault();
    if (typeof dlg.showModal === 'function') {
      dlg.showModal();
    } else {
      dlg.setAttribute('open', 'open'); // fallback
      document.body.style.overflow = 'hidden';
    }
  });

  // Fecha
  function closeDialog(){
    if (dlg.open && typeof dlg.close === 'function') dlg.close();
    else dlg.removeAttribute('open');
    document.body.style.overflow = '';
  }
  fechar.addEventListener('click', closeDialog);
  ok.addEventListener('click', closeDialog);

  // Fecha ao clicar fora (backdrop) – compatível com showModal
  dlg.addEventListener('click', (e) => {
    const rect = dlg.getBoundingClientRect();
    const outside = e.clientX < rect.left || e.clientX > rect.right ||
                    e.clientY < rect.top  || e.clientY > rect.bottom;
    if (outside) closeDialog();
  });

  // Fecha com ESC
  dlg.addEventListener('cancel', (e) => { e.preventDefault(); closeDialog(); });
})();
</script>

<script>
(function(){
  const link   = document.getElementById('abrir-diretrizes');
  const dlg    = document.getElementById('dlg-diretrizes');
  const fechar = document.getElementById('dlg-fechar');
  const ok     = document.getElementById('dlg-concordo');

  if (!link || !dlg) return;

  // Abre
  link.addEventListener('click', (e) => {
    e.preventDefault();
    if (typeof dlg.showModal === 'function') {
      dlg.showModal();
    } else {
      dlg.setAttribute('open', 'open'); // fallback
      document.body.style.overflow = 'hidden';
    }
  });

  // Fecha
  function closeDialog(){
    if (dlg.open && typeof dlg.close === 'function') dlg.close();
    else dlg.removeAttribute('open');
    document.body.style.overflow = '';
  }
  fechar.addEventListener('click', closeDialog);
  ok.addEventListener('click', closeDialog);

  // Fecha ao clicar fora (backdrop) – compatível com showModal
  dlg.addEventListener('click', (e) => {
    const rect = dlg.getBoundingClientRect();
    const outside = e.clientX < rect.left || e.clientX > rect.right ||
                    e.clientY < rect.top  || e.clientY > rect.bottom;
    if (outside) closeDialog();
  });

  // Fecha com ESC
  dlg.addEventListener('cancel', (e) => { e.preventDefault(); closeDialog(); });
})();
</script>



<script>
  // Service Worker (opcional, mantém como está)
  if ('serviceWorker' in navigator) {
    navigator.serviceWorker.register('/sistemaconsulta/service-worker.js', { scope: '/sistemaconsulta/' })
      .then(r => console.log('Service Worker registrado:', r.scope))
      .catch(err => console.error('Erro ao registrar Service Worker:', err));
  }
</script>


</body>
</html>
