// /sistemaconsulta/service-worker.js

self.addEventListener('push', (event) => {
  let data = {};
  try { data = event.data ? event.data.json() : {}; } catch (e) {}

  const scopeBase = new URL(self.registration.scope); // ex.: https://.../sistemaconsulta/
  const rel = (p) => new URL(p || '', scopeBase).toString();

  const title = data.title || 'Atualização da Fila';
  const body  = data.body  || 'Seu caminhão foi chamado.';
  const notifData = data.data || { url: 'resultado' };

  const options = {
    body,
    icon:  rel(data.icon  || 'assets/Logo-ATT2.png'),
    badge: rel(data.badge || 'assets/Logo-ATT2.png'),
    data:  { ...notifData, url: rel(notifData.url || 'resultado') },
  };

  event.waitUntil(self.registration.showNotification(title, options));
});

self.addEventListener('notificationclick', (event) => {
  event.notification.close();
  const targetUrl = (event.notification?.data?.url) || self.registration.scope;

  event.waitUntil(
    clients.matchAll({ type: 'window', includeUncontrolled: true }).then(list => {
      for (const c of list) {
        if (c.url.startsWith(self.registration.scope) && 'focus' in c) return c.focus();
      }
      return clients.openWindow(targetUrl);
    })
  );
});
