<?php
// Mostra erros para debug temporário
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/config.php';

// Número de teste — 55 + DDD + 9 + número
$numero   = '5543984779194';
$mensagem = "Olá! Este é um teste de envio automático via Z-API pelo sistema do Grupo ATT. 👍";

// Detecta qual função você tem no config (enviei variações em mensagens anteriores)
if (function_exists('enviarMensagemWhatsapp')) {
    $res = ['ok' => $ok, 'by' => 'enviarMensagemWhatsapp'];
} elseif (function_exists('enviarWhatsApp')) {
    $ok  = enviarWhatsApp($numero, $mensagem);
    $res = ['ok' => $ok, 'by' => 'enviarWhatsApp'];
} elseif (function_exists('zapi_send_text')) {
    $res = zapi_send_text($numero, $mensagem);
} else {
    $res = ['ok' => false, 'error' => 'Nenhuma função de envio encontrada no config.php'];
}

header('Content-Type: application/json; charset=utf-8');
echo json_encode($res, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE);
