<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require __DIR__ . '/../config.php'; // ajusta se o config.php estiver em outro lugar

// Arquivo onde vamos registrar os envios já feitos
$logFile = __DIR__ . "/notificados.json";

// Lê histórico de envios
$notificados = [];
if (is_file($logFile)) {
    $tmp = json_decode(file_get_contents($logFile), true);
    if (is_array($tmp)) $notificados = $tmp;
}

// 1) Buscar fila completa
$payload = ["AttApi" => ["tipoOperacao" => "d_posicao_fila"]];

$ch = curl_init(API_URL);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST           => true,
    CURLOPT_HTTPHEADER     => [
        "Content-Type: application/json",
        "token: " . API_TOKEN
    ],
    CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE),
    CURLOPT_TIMEOUT        => 20,
]);
$res = curl_exec($ch);
$err = curl_error($ch);
curl_close($ch);

if ($err || !$res) {
    echo "❌ Erro ao consultar API: $err<br>";
    exit;
}

$dados = json_decode($res, true);
$lista = $dados['dados']['listaFila'] ?? [];
if (!$lista) {
    echo "⚠️ Nenhum veículo na fila<br>";
    exit;
}

// 2) Loop nos veículos chamados
foreach ($lista as $v) {
    $placa  = strtoupper($v['veiculo_fila_descarga'] ?? '');
    $dataCh = $v['data_chamada_descarga'] ?? '';
    $horaCh = $v['hora_chamada_descarga'] ?? '';
    $telRaw = $v['celular_motorista'] ?? '';

    if ($placa && $dataCh && $horaCh && $telRaw) {
        $telefone = normalizarTelefoneBr($telRaw, 'inserir9');
        if (!$telefone) {
            echo "⚠️ Placa $placa chamada mas telefone inválido ($telRaw)<br>";
            continue;
        }

        // ID único do evento (placa + data + hora)
        $id = $placa . "|" . $dataCh . "|" . substr($horaCh, 0, 5);

        // Verifica se já foi notificado
        if (!empty($notificados[$id])) {
            echo "⏭️ Já notificado: $id<br>";
            continue;
        }

        // Monta mensagem
        $mensagem = montarMensagemChamado(
            $placa,
            formatarDataBr($dataCh),
            substr($horaCh, 0, 5)
        );

        // Enviar JSON para webhook do Z-API
        $json = json_encode([
            "phone"   => $telefone,
            "message" => $mensagem
        ], JSON_UNESCAPED_UNICODE);

        $ch2 = curl_init("https://consulta.grupoatt.log.br/sistemaconsulta/webhooks/enviar.php");
        curl_setopt_array($ch2, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST           => true,
            CURLOPT_HTTPHEADER     => ["Content-Type: application/json"],
            CURLOPT_POSTFIELDS     => $json,
            CURLOPT_TIMEOUT        => 20,
        ]);
        $resp = curl_exec($ch2);
        $err2 = curl_error($ch2);
        curl_close($ch2);

        if ($err2) {
            echo "❌ Erro ao chamar enviar.php para $placa: $err2<br>";
        } else {
            echo "✅ Disparado ($id → $telefone) | Resposta: $resp<br>";

            // Marca como notificado
            $notificados[$id] = [
                'quando'   => date('c'),
                'placa'    => $placa,
                'telefone' => $telefone
            ];
            file_put_contents($logFile, json_encode($notificados, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        }
    }
}
